<?php
// This file generates the CSS overrides from the admin interface. It will be included only
// when needed.
function ttw_save_current_css() {
    // write the current generated CSS to a file

    $wpdir = wp_upload_dir();		// get the upload directory

    $save_dir = $wpdir['basedir'] . '/weaver-subthemes';
    $save_url = $wpdir['baseurl'] . '/weaver-subthemes';

    $usename = 'style-weaver.css';

    $ttw_theme_dir_exists = wp_mkdir_p($save_dir);
    $ttw_theme_dir_writable = $ttw_theme_dir_exists;

    if (!$ttw_theme_dir_exists) {      // it either already exisits, or was created
	    echo '<div class="error"><p>';
	    echo 'It looks like <strong>'.$save_dir.'</strong> does not exist.<br /><br /> This error is unusual and probably involves a site configuration issue. Have you changed hosts recently?';
	    echo "\nThis message might have some useful information:<br />\n"; var_dump($wpdir);
	    echo '</p></div><br />';

    } else if (!is_writable($save_dir)) {
        if(!is_writable($save_dir)){
            echo '<div class="error"><p>';
	    echo 'It looks like <strong>'.$save_dir.'</strong> is not writable.<br /><br /> You will need to directory writable in order to save sub-themes on your site.<br /><br />Maybe <a href="http://codex.wordpress.org/Changing_File_Permissions" target="_blank">This Article</a> from WordPress will help.';
	    echo '</p></div><br />';
            $ttw_theme_dir_writable = false;
        }
    }

    $filename = $save_dir . '/'. $usename;    // we will add txt

    if (!$ttw_theme_dir_writable || !($handle = fopen($filename, 'w')) ) {
	?>
	    <h4>Sorry, something went wrong.</h4>
	    <p>Unable to create the file to save the theme CSS file on your site host. It is likely
	    some kind of file permission problem. The site will continue to function properly
	    using inline CSS, but this message will continue to be displayed.</p>
	    <?php
	    return '';
	}

    fwrite($handle,sprintf("/* WARNING: Do not edit this file. It is dynamically generated. Any edits you make will be overwritten. */
/* This file generated using %s %s subtheme: %s */\n",TTW_THEMENAME, TTW_VERSION, ttw_getopt('ttw_subtheme')));

    ttw_output_style($handle);
    fclose($handle);

    return $save_url . '/' . $usename;
}

function ttw_output_style($sout) {
    /* This outputs the CSS overrides. It will output to a file pointer, so it can write to a .css file saved
       in the user's upload directory - just like the saved style .wvr files. It is included via a standard
       css include. It needs to be loaded only for the admin page.
    */

// Put a options that can be overridden by the CSS option at the top!
     fwrite($sout, sprintf("/* General Options */\n"));

/*  ttw_after_header  */

    if (($optVal = ttw_getopt("ttw_after_header")) != ttw_getopt_std("ttw_after_header")) {
	fwrite($sout, sprintf("#main {padding: %spx 0 0 0;}\n", $optVal));
    }

/*  ttw_bold_menu  */

    if (ttw_getopt("ttw_bold_menu")) {
	fwrite($sout, sprintf("#access, #access li ul ul > a {font-weight:bold;}\n"));
	fwrite($sout, sprintf("#access2, #access2 li ul ul > a {font-weight:bold;}\n"));
    }

/*  ttw_contentlist_bullet  */

    $val = ttw_getopt("ttw_contentlist_bullet");       /* add a new lsit bullet */
    if ($val && $val != '' && $val != 'default') {
	if ($val == 'none' || $val == 'circle' || $val == 'disc' || $val == 'square')
	    fwrite($sout, sprintf("ul {list-style:%s;}\n",$val));
	else
            fwrite($sout, sprintf("ul {list-style:none;list-style-image: url(%s/images/bullets/%s.gif);}\n",
		get_template_directory_uri(),$val));
    }


/*  ttw_content_font  */

    if (($useFont = t_get_font_value('ttw_content_font')) != '') {
	t_css_fontfamily($sout,'body, input, textarea, .page-title span, .pingback a.url', $useFont);
    }

/*  ttw_fadebody_bg  */

    if (ttw_getopt('ttw_fadebody_bg')) {
	fwrite($sout, sprintf("body {background-image: url(%s/images/gr.png); background-attachment: scroll; background-repeat: repeat-x;}\n",
	       get_template_directory_uri()));
    }

/*  ttw_gradient_menu  */

    if (ttw_getopt('ttw_gradient_menu')) {
	fwrite($sout, sprintf("#access, #access2 { background-image: url(%s/images/weaver/fade.png);}\n",
	       get_template_directory_uri()));
	fwrite($sout, sprintf("#access ul ul a, #access li:hover > a, #access ul ul :hover > a  { background-image: url(%s/images/weaver/fadeup.png);}\n",
	       get_template_directory_uri()));
	fwrite($sout, sprintf("#access2 ul ul a, #access2 li:hover > a, #access2 ul ul :hover > a  { background-image: url(%s/images/weaver/fadeup.png);}\n",
	       get_template_directory_uri()));
   }

/*  ttw_hide_post_fill  (also used in post icons) */

    if (ttw_getopt('ttw_hide_post_fill')) {
	fwrite($sout, sprintf(".entry-utility-prep {display: none;}\n.meta-prep-author {display:none;}\n.meta-sep {display: none;}\n"));
    }


/*  ttw_large_tagline  */

    if (ttw_getopt('ttw_large_tagline')) {
	fwrite($sout, sprintf('#site-description {font-size:130%%; font-weight:bold;}'));
    }

/*  ttw_list_bullet  */

    $val = ttw_getopt('ttw_list_bullet');       /* add a new lsit bullet */
    if ($val && $val != '' && $val != 'default') {
	if ($val == 'none' || $val == 'circle' || $val == 'disc' || $val == 'square')
	    fwrite($sout, sprintf(".widget-area ul ul {list-style:%s;}\n",$val));
	else
	    fwrite($sout, sprintf(".widget-area ul ul {list-style:none; list-style-position:inside; list-style-image: url(%s/images/bullets/%s.gif);}\n",
	       get_template_directory_uri(),$val));
    }

/*  ttw_post_icons  */

   if (ttw_getopt('ttw_post_icons')) {
	$leftm = '8';
	if (!ttw_getopt('ttw_hide_post_fill')) $leftm = '0';	// no left margin if not hiding fill in
	fwrite($sout, sprintf(".cat-links {background: url(%s/images/icons/category-1.png) no-repeat 1px;padding-top:3px;padding-left:23px;}\n",
	    get_template_directory_uri()));
	fwrite($sout, sprintf(".vcard {background: url(%s/images/icons/author-1.png) no-repeat;padding-top: 2px;padding-left:21px;margin-left:%spx;}\n",
	       	    get_template_directory_uri(),$leftm));
	fwrite($sout, sprintf(".entry-meta {background: url(%s/images/icons/date-1.png) no-repeat 1px;padding-top:1px;padding-left:26px;}\n",
	    get_template_directory_uri()));
	fwrite($sout, sprintf(".comments-link {background: url(%s/images/icons/comment-1.png) no-repeat 1px; padding-left:24px;padding-top:2px;margin-left:%spx;}\n",
	       get_template_directory_uri(),$leftm));
	fwrite($sout, sprintf(".tag-links {background: url(%s/images/icons/tag-1.png) no-repeat 1px;padding-top:2px;padding-left:24px;margin-left:%spx;}\n",
	       get_template_directory_uri(),$leftm));
	fwrite($sout, sprintf(".edit-link{ background: url(%s/images/icons/edit-1.png) no-repeat 1px;padding-top:3px;padding-left:21px;margin-left:%spx;}\n",
	       get_template_directory_uri(),$leftm));
   }


/*  ttw_small_content_font  */

    if (ttw_getopt('ttw_small_content_font')) {
	fwrite($sout, sprintf("#content {font-size: 120%%; line-height: 125%%; }\n"));  /* stange, but true! */
	fwrite($sout, sprintf("#comments {font-size: 90%%; line-height: 90%%; }\n"));  /* stange, but true! */
    }

/*  ttw_title_font  */

if (($useFont = t_get_font_value('ttw_title_font')) != '') {
	t_css_fontfamily($sout,
'h3#comments-title, h3#reply-title, #access .menu, #access div.menu ul, #access2 .menu, #access2 div.menu ul,
#cancel-comment-reply-link, .form-allowed-tags, #site-info, #site-title, #wp-calendar,
.comment-meta, .comment-body tr th, .comment-body thead th, .entry-content label, .entry-content tr th,
.entry-content thead th, .entry-meta, .entry-title, .entry-utility, #respond label, .navigation,
.page-title, .pingback p, .reply, .widget_search label, .widget-title, input[type=submit]', $useFont);
    }



/*  ttw_useborders  */

    if (ttw_getopt('ttw_useborders')) {
        fwrite($sout, sprintf("#wrapper {border: 1px solid #222222; padding-right: 20px; margin-top: 15px; margin-bottom: 15px;}\n"));
        fwrite($sout, sprintf("#header {margin-top: 0px;}\n"));
	fwrite($sout, sprintf("#primary, #secondary, #altleft, #altright, #ttw-top-widget, #ttw-bot-widget, #altleft, #altright {border: 1px solid #222222;}\n"));
    }

/*  ttw_rounded_corners  */

    if (ttw_getopt('ttw_rounded_corners')) {
        fwrite($sout, sprintf("#container, #primary, #secondary, #altleft, #altright,
 #ttw-top-widget, #ttw-bot-widget {-moz-border-radius: 10px; -webkit-border-radius: 10px; border-radius: 10px;}\n"));
	if (ttw_getopt('ttw_move_menu')) {
	    fwrite($sout, sprintf("#access2 {-moz-border-radius-bottomleft: 7px; -moz-border-radius-bottomright: 7px;
 -webkit-border-bottom-left-radius: 7px; -webkit-border-bottom-right-radius: 7px; border-bottom-left-radius: 7px; border-bottom-right-radius: 7px;}\n"));
	    fwrite($sout, sprintf("#access {-moz-border-radius-topleft: 7px; -moz-border-radius-topright: 7px;
 -webkit-border-top-left-radius: 7px; -webkit-border-top-right-radius: 7px; border-top-left-radius: 7px; border-top-right-radius: 7px;}\n"));
	} else {
	    fwrite($sout, sprintf("#access {-moz-border-radius-bottomleft: 7px; -moz-border-radius-bottomright: 7px;
 -webkit-border-bottom-left-radius: 7px; -webkit-border-bottom-right-radius: 7px;border-bottom-left-radius: 7px; border-bottom-right-radius: 7px;}\n"));
	    fwrite($sout, sprintf("#access2 {-moz-border-radius-topleft: 7px; -moz-border-radius-topright: 7px;
 -webkit-border-top-left-radius: 7px; -webkit-border-top-right-radius: 7px;border-top-left-radius: 7px; border-top-right-radius: 7px;}\n"));
	}
        fwrite($sout, sprintf("#wrapper {-moz-border-radius: 10px; -webkit-border-radius: 10px; border-radius: 10px; margin-top: 15px; margin-bottom: 15px;}\n"));
    }

// ------------------------------------------- end of overrideable options -------------------------------
/* Generate the sidebar CSS last since it might override some other settings */
    fwrite($sout, sprintf("/* Sidebar arrangement */\n"));

    ttw_sidebar_css($sout);	// complicated code in its own function...

/*  ttw_title_on_header  - needs to be here... */

    fwrite($sout, sprintf("/* Color and custom CSS */\n"));

    if (ttw_getopt('ttw_title_on_header')) {
	fwrite($sout, sprintf("#site-title {position: absolute; margin-top: 44px; margin-left: 40px; }
#site-description { text-align:left; clear: both; float: left; position:absolute;  margin-top: 90px;  margin-left: 40px;}\n"));
    }

/*  ttw_body_bgcolor  */

    if (($optVal = ttw_getopt_newcolor('ttw_body_bgcolor'))) {
	t_css_bgcolor($sout,'body',$optVal);
    }
    if (($optVal = ttw_getopt('ttw_body_bgcolor_css'))) {
	t_css_css($sout,'body',$optVal);
    }

/*  ttw_container_bgcolor  */

    if (($optVal = ttw_getopt("ttw_container_bgcolor"))) {
	t_css_bgcolor($sout,'#container',$optVal);
    }
    if (($optVal = ttw_getopt("ttw_container_bgcolor_css"))) {
	t_css_css($sout,'#container',$optVal);
    }

/*  ttw_content_bgcolor  */

    if (($optVal = ttw_getopt("ttw_content_bgcolor"))) {
	t_css_bgcolor($sout,'#content',$optVal);
    }
    if (($optVal = ttw_getopt('ttw_content_bgcolor_css'))) {
	t_css_css($sout,'#content',$optVal);
    }

/*  ttw_content_color  */
    if (($optVal = ttw_getopt_newcolor('ttw_content_color')) ) {
	t_css_color($sout,'#content, #content input, #content textarea',$optVal);
    }
    if (($optVal = ttw_getopt('ttw_content_color_css')) ) {
	t_css_css($sout,'#content, #content input, #content textarea',$optVal);
    }

/*  ttw_desc_color  */

    if (($optVal = ttw_getopt_newcolor('ttw_desc_color'))) {
	fwrite($sout, sprintf("#site-description {color: ".$optVal.";}\n"));
    }
    if (($optVal = ttw_getopt('ttw_desc_color_css'))) {
	t_css_css($sout,"#site-description", $optVal);
    }

/*  ttw_excerpt_length - no CSS */

/*  ttw_footer_bgcolor  */

    if (($optVal = ttw_getopt("ttw_footer_bgcolor"))) {
	t_css_bgcolor($sout,'#footer',$optVal);
    }
    if (($optVal = ttw_getopt("ttw_footer_bgcolor_css"))) {
	t_css_css($sout,'#footer',$optVal);
    }

/*  ttw_footer_border_color  */

    if (($optVal = ttw_getopt_newcolor('ttw_footer_border_color'))) {
	fwrite($sout, sprintf("#colophon { border-top: 4px solid $optVal ;  }\n"));
    }
    if (($optVal = ttw_getopt("ttw_footer_border_color_css"))) {
	t_css_css($sout,'#colophon',$optVal);
    }

/*    ttw_footer_widget_bgcolor */

    if (($optVal = ttw_getopt('ttw_footer_widget_bgcolor'))) {
	t_css_bgcolor($sout,'#first,#second, #third, #fourth',$optVal,'padding-left: 10px; padding-top: 10px; margin-bottom: 5px;');
    }
    if (($optVal = ttw_getopt('ttw_footer_widget_bgcolor_css'))) {
	t_css_css($sout,'#first,#second, #third, #fourth',$optVal);
    }

/*  ttw_force_widg_frontpage - no CSS */

/*  ttw_header_bgcolor  */

    if (($optVal = ttw_getopt("ttw_header_bgcolor"))) {
	t_css_bgcolor($sout,'#header',$optVal);
    }
    if (($optVal = ttw_getopt("ttw_header_bgcolor_css"))) {
	t_css_css($sout,'#header',$optVal);
    }

/*  ttw_header_image_height - no CSS*/
/*  ttw_header_image_width - no CSS (used in width calculations, however)  */

/*  ttw_header_underline  */

    $val = (int)ttw_getopt('ttw_header_underline');       /* bar under headers */
    if ($val != '' && $val != 0) {
        $titleColor = ttw_getopt('ttw_text_color');
        fwrite($sout, sprintf(".entry-title {border-bottom: $val"."px solid $titleColor;}\n"));
    }

/*  ttw_hide_menu - no CSS */
/*  ttw_hide_site_title - no CSS */
/*  ttw_hide_widg_pages - no CSS */
/*  ttw_hide_widg_posts - no CSS */

/*  ttw_hr_color  */

    if (($optVal = ttw_getopt_newcolor('ttw_hr_color'))) {
	t_css_bgcolor($sout,'hr',$optVal);
    }
    if (($optVal = ttw_getopt('ttw_hr_color_css'))) {
	t_css_css($sout,'hr',$optVal);
    }

/*  ttw_ilink_color  */
/*  ttw_ilink_hover_color  */
/*  ttw_ilink_visited_color  */

    if (($optVal = ttw_getopt_newcolor("ttw_ilink_color"))) { /* post title links */
	t_css_color($sout,'.page-title a:link', $optVal);
	t_css_color($sout,'.entry-meta a:link', $optVal);
	t_css_color($sout,'.entry-utility a:link', $optVal);
	t_css_color($sout,'.navigation a:link', $optVal);
	t_css_color($sout,'.comment-meta a:link', $optVal);
	t_css_color($sout,'.reply a:link, a.comment-edit-link:link', $optVal);
    }
    if (($optVal = ttw_getopt_newcolor("ttw_ilink_hover_color"))) {
	t_css_color($sout,'.page-title a:active, .page-title a:hover', $optVal);
	t_css_color($sout,'.entry-meta a:hover, .entry-meta a:active', $optVal);
	t_css_color($sout,'.entry-utility a:hover, .entry-utility a:active', $optVal);
	t_css_color($sout,'.navigation a:active, .navigation a:hover', $optVal);
	t_css_color($sout,'.comment-meta a:active, .comment-meta a:hover', $optVal);
	t_css_color($sout,'.reply a:active, a.comment-edit-link:active, .reply a:hover, a.comment-edit-link:hover', $optVal);
    }
    if (($optVal = ttw_getopt_newcolor("ttw_ilink_visited_color"))) {
	t_css_color($sout,'.page-title a:visited', $optVal);
	t_css_color($sout,'.entry-meta a:visited', $optVal);
	t_css_color($sout,'.entry-utility a:visited', $optVal);
	t_css_color($sout,'.navigation a:visited', $optVal);
	t_css_color($sout,'.comment-meta a:visited', $optVal);
	t_css_color($sout,'.reply a:visited, a.comment-edit-link:visited', $optVal);
    }
    if (($optVal = ttw_getopt("ttw_ilink_color_css"))) { /* post title links */
	t_css_css($sout,'.page-title a:link', $optVal);
	t_css_css($sout,'.entry-meta a:link', $optVal);
	t_css_css($sout,'.entry-utility a:link', $optVal);
	t_css_css($sout,'.navigation a:link', $optVal);
	t_css_css($sout,'.comment-meta a:link', $optVal);
	t_css_css($sout,'.reply a:link, a.comment-edit-link:link', $optVal);
    }
    if (($optVal = ttw_getopt("ttw_ilink_hover_color_css"))) {
	t_css_css($sout,'.page-title a:active, .page-title a:hover', $optVal);
	t_css_css($sout,'.entry-meta a:hover, .entry-meta a:active', $optVal);
	t_css_css($sout,'.entry-utility a:hover, .entry-utility a:active', $optVal);
	t_css_css($sout,'.navigation a:active, .navigation a:hover', $optVal);
	t_css_css($sout,'.comment-meta a:active, .comment-meta a:hover', $optVal);
	t_css_css($sout,'.reply a:active, a.comment-edit-link:active, .reply a:hover, a.comment-edit-link:hover', $optVal);
    }
    if (($optVal = ttw_getopt("ttw_ilink_visited_color_css"))) {
	t_css_css($sout,'.page-title a:visited', $optVal);
	t_css_css($sout,'.entry-meta a:visited', $optVal);
	t_css_css($sout,'.entry-utility a:visited', $optVal);
	t_css_css($sout,'.navigation a:visited', $optVal);
	t_css_css($sout,'.comment-meta a:visited', $optVal);
	t_css_css($sout,'.reply a:visited, a.comment-edit-link:visited', $optVal);
    }

/*  ttw_info_color  */

    if (($infoColor = ttw_getopt_newcolor('ttw_info_color'))) {
        t_css_color($sout,'#comments .pingback p', $infoColor);
	t_css_color($sout,'#respond label, #respond dt, #respond dd', $infoColor);
	t_css_color($sout,'.entry-meta, .entry-content label, .entry-utility', $infoColor);
	t_css_color($sout,'#content .wp-caption, #content .gallery .gallery-caption', $infoColor);
	t_css_color($sout,'.navigation', $infoColor);
    }
    if (($infoColor = ttw_getopt('ttw_info_color_css'))) {
        t_css_css($sout,'#comments .pingback p', $infoColor);
	t_css_css($sout,'#respond label, #respond dt, #respond dd', $infoColor);
	t_css_css($sout,'.entry-meta, .entry-content label, .entry-utility', $infoColor);
	t_css_css($sout,'#content .wp-caption, #content .gallery .gallery-caption', $infoColor);
	t_css_css($sout,'.navigation', $infoColor);
    }

/*  ttw_infotop_bgcolor, ttw_infobottom_bgcolor  */

    if (($optVal = ttw_getopt('ttw_infotop_bgcolor'))) {
	t_css_bgcolor($sout,'.entry-meta',$optVal);
    }
    if (($optVal = ttw_getopt('ttw_infotop_bgcolor_css'))) {
	t_css_css($sout,'.entry-meta',$optVal);
    }
    if (($optVal = ttw_getopt('ttw_infobottom_bgcolor'))) {
	t_css_bgcolor($sout,'.entry-utility',$optVal);
    }
    if (($optVal = ttw_getopt('ttw_infobottom_bgcolor_css'))) {
	t_css_css($sout,'.entry-utility',$optVal);
    }

/*  ttw_input_bgcolor  */

    if (($optVal = ttw_getopt('ttw_input_bgcolor'))) {
	t_css_bgcolor($sout,'input[type="text"], textarea, input[type="submit"], ins',$optVal);
    }
    if (($optVal = ttw_getopt('ttw_input_bgcolor_css'))) {
	t_css_css($sout,'input[type="text"], textarea, input[type="submit"], ins',$optVal);
    }

/*  ttw_link_color  */
/*  ttw_link_hover_color  */
/*  ttw_link_visited_color  */

    if (($optVal = ttw_getopt_newcolor('ttw_link_color'))) {
	t_css_color($sout,'a:link', $optVal);
    }
    if (($optVal = ttw_getopt_newcolor('ttw_link_hover_color'))) {
	t_css_color($sout,'a:active, a:hover', $optVal);
    }
    if (($optVal = ttw_getopt_newcolor('ttw_link_visited_color'))) {
	t_css_color($sout,'a:visited', $optVal);
    }
    if (($optVal = ttw_getopt('ttw_link_color_css'))) {
	t_css_css($sout,'a:link', $optVal);
    }
    if (($optVal = ttw_getopt('ttw_link_hover_color_css'))) {
	t_css_css($sout,'a:active, a:hover', $optVal);
    }
    if (($optVal = ttw_getopt('ttw_link_visited_color_css'))) {
	t_css_css($sout,'a:visited', $optVal);
    }

/*  ttw_link_site_image - no CSS */

/*  ttw_main_bgcolor  */

    if (($optVal = ttw_getopt('ttw_main_bgcolor'))) {
	t_css_bgcolor($sout,'#main',$optVal);
    }
    if (($optVal = ttw_getopt('ttw_main_bgcolor_css'))) {
	t_css_css($sout,'#main',$optVal);
    }

    /*  ttw_caption_color  */

    if (($optVal = ttw_getopt_newcolor('ttw_caption_color'))) {
	t_css_color($sout,'#content .wp-caption p.wp-caption-text',$optVal);
    }
    if (($optVal = ttw_getopt('ttw_caption_color_css'))) {
	t_css_css($sout,'#content .wp-caption p.wp-caption-text',$optVal);
    }

/*    ttw_media_lib_border    */

    if (($optVal = ttw_getopt('ttw_media_lib_border'))) {
	fwrite($sout, sprintf("#content .size-full, #content .size-large, #content .size-medium, #content .size-thumbnail,#content .size-thumbnail {background-color: %s;}\n",
	    $optVal  ));
    }
    if (($optVal = ttw_getopt('ttw_media_lib_border_css'))) {
	t_css_css($sout,'#content .size-full, #content .size-large, #content .size-medium, #content .size-thumbnail',$optVal);
    }

/*    ttw_media_lib_captioned_border    */

    if (($optVal = ttw_getopt('ttw_media_lib_captioned_border'))) {
	fwrite($sout, sprintf("#content .wp-caption p.wp-caption-text,
#content .wp-caption .size-full, #content .wp-caption .size-large, #content .wp-caption .size-medium,
#content .wp-caption .size-thumbnail, #content .wp-caption .size-thumbnail {background-color: %s;}\n",
	    $optVal  ));
    }
    if (($optVal = ttw_getopt('ttw_media_lib_captioned_border_css'))) {
	t_css_css($sout,'#content .wp-caption p.wp-caption-text,
#content .wp-caption .size-full, #content .wp-caption .size-large, #content .wp-caption .size-medium,
#content .wp-caption .size-thumbnail, #content .wp-caption .size-thumbnail',
	    $optVal);
    }

/*  ttw_menubar_color  */

    if (($optVal = ttw_getopt_newcolor('ttw_menubar_color'))) {
	t_css_bgcolor($sout,'#access, #access2', $optVal);
    }
    if (($optVal = ttw_getopt('ttw_menubar_color_css'))) {
	t_css_css($sout,'#access, #access2', $optVal);
    }

/*  ttw_menubar_curpage_color  */

    if (($optVal = ttw_getopt_newcolor('ttw_menubar_curpage_color'))) {
	t_css_color($sout,'#access ul li.current_page_item > a, #access ul li.current-menu-ancestor > a,
#access ul li.current-menu-item > a, #access ul li.current-menu-parent > a', $optVal);
	t_css_color($sout,'#access2 ul li.current_page_item > a, #access2 ul li.current-menu-ancestor > a,
#access2 ul li.current-menu-item > a, #access ul li.current-menu-parent > a', $optVal);
    }
    if (($optVal = ttw_getopt('ttw_menubar_curpage_color_css'))) {
	t_css_css($sout,'#access ul li.current_page_item > a, #access ul li.current-menu-ancestor > a,
#access ul li.current-menu-item > a, #access ul li.current-menu-parent > a', $optVal);
	t_css_css($sout,'#access2 ul li.current_page_item > a, #access2 ul li.current-menu-ancestor > a,
#access2 ul li.current-menu-item > a, #access ul li.current-menu-parent > a', $optVal);
    }

/*  ttw_menubar_hover_color  */
/*  ttw_menubar_hoverbg_color  */
/*  ttw_menubar_text_color  */

    if (($optVal = ttw_getopt_newcolor('ttw_menubar_hover_color'))) {
	t_css_color($sout,'#access li:hover > a, #access ul ul :hover > a', $optVal);
	t_css_color($sout,'#access2 li:hover > a, #access2 ul ul :hover > a', $optVal);
    }
    if (($optVal = ttw_getopt_newcolor('ttw_menubar_hoverbg_color'))) {
	t_css_bgcolor($sout,'#access ul ul a, #access li:hover > a, #access ul ul :hover > a ', $optVal);
	t_css_bgcolor($sout,'#access2 ul ul a, #access2 li:hover > a, #access2 ul ul :hover > a ', $optVal);
    }
    if (($optVal = ttw_getopt_newcolor('ttw_menubar_text_color'))) {
	t_css_color($sout,'#access a', $optVal);
	t_css_color($sout,'#access2 a', $optVal);
    }
    if (($optVal = ttw_getopt('ttw_menubar_hover_color_css'))) {
	t_css_css($sout,'#access li:hover > a, #access ul ul :hover > a', $optVal);
	t_css_css($sout,'#access2 li:hover > a, #access2 ul ul :hover > a', $optVal);
    }
    if (($optVal = ttw_getopt('ttw_menubar_hoverbg_color_css'))) {
	t_css_css($sout,'#access ul ul a, #access li:hover > a, #access ul ul :hover > a ', $optVal);
	t_css_css($sout,'#access2 ul ul a, #access2 li:hover > a, #access2 ul ul :hover > a ', $optVal);
    }
    if (($optVal = ttw_getopt('ttw_menubar_text_color_css'))) {
	t_css_css($sout,'#access a', $optVal);
	t_css_css($sout,'#access2 a', $optVal);
    }

/*  ttw_move_menu - no CSS (used by rounded corners) */

/*  ttw_page_bgcolor  */

    if (($optVal = ttw_getopt('ttw_page_bgcolor'))) {
	t_css_bgcolor($sout,'#wrapper',$optVal);
    }
    if (($optVal = ttw_getopt('ttw_page_bgcolor_css'))) {
	t_css_css($sout,'#wrapper',$optVal);
    }

/*  ttw_plink_color  */
/*  ttw_plink_hover_color  */
/*  ttw_plink_visited_color  */

    if (($optVal = ttw_getopt_newcolor('ttw_plink_color'))) { /* post title links */
    	t_css_color($sout,'.entry-title a:link', $optVal);
	t_css_color($sout,'.widget_rss a.rsswidget:link', $optVal);
    }
    if (($optVal = ttw_getopt_newcolor('ttw_plink_hover_color'))) {
    	t_css_color($sout,'.entry-title a:active, .entry-title a:hover', $optVal);
    	t_css_color($sout,'.widget_rss a.rsswidget:active, .widget_rss a.rsswidget:hover', $optVal);
    }
    if (($optVal = ttw_getopt_newcolor('ttw_plink_visited_color'))) {
    	t_css_color($sout,'.entry-title a:visited', $optVal);
    	t_css_color($sout,'.widget_rss a.rsswidget:visited', $optVal);
    }
    if (($optVal = ttw_getopt('ttw_plink_color_css'))) { /* post title links */
    	t_css_css($sout,'.entry-title a:link', $optVal);
	t_css_css($sout,'.widget_rss a.rsswidget:link', $optVal);
    }
    if (($optVal = ttw_getopt('ttw_plink_hover_color_css'))) {
    	t_css_css($sout,'.entry-title a:active, .entry-title a:hover', $optVal);
    	t_css_css($sout,'.widget_rss a.rsswidget:active, .widget_rss a.rsswidget:hover', $optVal);
    }
    if (($optVal = ttw_getopt('ttw_plink_visited_color_css'))) {
    	t_css_css($sout,'.entry-title a:visited', $optVal);
    	t_css_css($sout,'.widget_rss a.rsswidget:visited', $optVal);
    }

    /*  ttw_post_bgcolor  */

    if (($optVal = ttw_getopt('ttw_post_bgcolor'))) {
	t_css_bgcolor($sout,'.post',$optVal);
    }
    if (($optVal = ttw_getopt('ttw_post_bgcolor_css'))) {
	t_css_css($sout,'.post',$optVal);
    }

/*  ttw_side1_bgcolor  */
/*  ttw_side2_bgcolor  */
/*  ttw_side3_bgcolor  */

    if (($optVal = ttw_getopt('ttw_side1_bgcolor'))) {
	t_css_bgcolor($sout,'#primary',$optVal, 'padding-left: 10px; padding-top: 10px; margin-bottom: 5px;');
    }
    if (($optVal = ttw_getopt('ttw_side2_bgcolor'))) {
	t_css_bgcolor($sout,'#secondary',$optVal, 'padding-left: 10px; padding-top: 10px; margin-bottom: 5px;');
    }
    if (($optVal = ttw_getopt('ttw_side3_bgcolor'))) {
	t_css_bgcolor($sout,'#altright, #altleft',$optVal,'padding-left: 10px; padding-top: 10px; margin-bottom: 5px;');
    }
    if (($optVal = ttw_getopt('ttw_side1_bgcolor_css'))) {
	t_css_css($sout,'#primary',$optVal);
    }
    if (($optVal = ttw_getopt('ttw_side2_bgcolor_css'))) {
	t_css_css($sout,'#secondary',$optVal);
    }
    if (($optVal = ttw_getopt('ttw_side3_bgcolor_css'))) {
	t_css_css($sout,'#altright, #altleft',$optVal);
    }

/*  ttw_sidebar_width  */
/*  ttw_sidebars  */
/* 	The CSS for sidebars is generated last because it might override some other settings  */


/*  ttw_stickypost_bgcolor  */

    if (($optVal = ttw_getopt('ttw_stickypost_bgcolor'))) {
	t_css_bgcolor($sout,'.home .sticky, #entry-author-info',$optVal);
    }
    if (($optVal = ttw_getopt('ttw_stickypost_bgcolor_css'))) {
	t_css_css($sout,'.home .sticky, #entry-author-info',$optVal);
    }

/*  ttw_text_color  */

    if (($textColor = ttw_getopt_newcolor('ttw_text_color'))) {
	t_css_color($sout,'#content h1, #content h2, #content h3, #content h4, #content h5, #content h6',$textColor);
	t_css_color($sout,'h1, h2, h3, h4, h5, h6',$textColor);
	t_css_color($sout,'.page-title',$textColor);
	t_css_color($sout,'.page-link',$textColor);
	t_css_color($sout,'#entry-author-info h2',$textColor);
	t_css_color($sout,'h3#comments-title, h3#reply-title',$textColor);
	t_css_color($sout,'.comment-author cite',$textColor);
	t_css_color($sout,'.entry-content fieldset legend',$textColor);
    }
    if (($textColor = ttw_getopt('ttw_text_color_css'))) {
	t_css_css($sout,'#content h1, #content h2, #content h3, #content h4, #content h5, #content h6',$textColor);
	t_css_css($sout,'h1, h2, h3, h4, h5, h6',$textColor);
	t_css_css($sout,'.page-title',$textColor);
	t_css_css($sout,'.page-link',$textColor);
	t_css_css($sout,'#entry-author-info h2',$textColor);
	t_css_css($sout,'h3#comments-title, h3#reply-title',$textColor);
	t_css_css($sout,'.comment-author cite',$textColor);
	t_css_css($sout,'.entry-content fieldset legend',$textColor);
    }

/*  ttw_page_title_color - MUST come after ttw_text_color! */

   if (($textColor = ttw_getopt_newcolor('ttw_page_title_color'))) {
	t_css_color($sout,'#content .entry-title',$textColor);
    } else if (($textColor = ttw_getopt_newcolor('ttw_text_color'))) {	// this gives backward compatibility pre-1.5
	t_css_color($sout,'#content .entry-title',$textColor);
    }
    if (($textColor = ttw_getopt('ttw_page_title_color_css'))) {	// not pre-1.5, so no worry
	t_css_css($sout,'#content .entry-title',$textColor);
    }


/*  ttw_title_color  */

    if (($optVal = ttw_getopt_newcolor('ttw_title_color'))) {
	fwrite($sout, sprintf("#site-title a { color: ".$optVal."; }\n"));
    }
    if (($optVal = ttw_getopt('ttw_title_color_css'))) {
	t_css_css($sout,'#site-title',$optVal);
    }

/*  ttw_topbottom_bgcolor  */

    if (($optVal = ttw_getopt('ttw_topbottom_bgcolor'))) {
	t_css_bgcolor($sout,'#ttw-top-widget, #ttw-bot-widget',$optVal, 'padding-left: 10px; padding-top: 10px; margin-bottom: 10px;');
    }
    if (($optVal = ttw_getopt('ttw_topbottom_bgcolor_css'))) {
	t_css_css($sout,'#ttw-top-widget, #ttw-bot-widget',$optVal);
    }

/*  ttw_weaver_tables  */
    $table = ttw_getopt('ttw_weaver_tables');

     if ($table == 'Default' || !$table) {	// make backward compatible with 1.4 and before when Twenty Ten was default
	fwrite($sout, sprintf("#content table {border: 1px solid #e7e7e7;margin: 0 -1px 24px 0;text-align: left;width: 100%%;}
#content tr th,#content thead th {color: #888;font-size: 12px;font-weight: bold;line-height: 18px;padding: 9px 24px;}
#content tr td {border-style:none; border-top: 1px solid #e7e7e7; padding: 6px 24px;}
#content tr.odd td {background: #f2f7fc;}\n"));
    } else
    if ($table == 'Bold Headings') {
	fwrite($sout, sprintf("#content table {border: 2px solid #888;}
#content tr th, #content thead th {font-weight: bold;}
#content tr td {border: 1px solid #888;}\n"));
    } else
    if ($table == 'No Borders') {
	fwrite($sout, sprintf("#content table {border-style:none;}
#content tr th, #content thead th {font-weight: bold;border-bottom: 1px solid #888;background-color:transparent;}
#content tr td {border-style:none;}\n"));
    } else
    if ($table == 'Full Width') {
	fwrite($sout, sprintf("#content table {width:100%%;}
#content tr th, #content thead th {font-weight:bold;}\n"));
    } else {
	// make backward compatible - checked meant Weaver
	fwrite($sout, sprintf("/* Weaver Tables - use default style.css */\n"));
    }

/*  ttw_wide_top_bottom - used by sidebar calcs */

/*  ttw_widget_color  */

    if (($widgetColor = ttw_getopt_newcolor('ttw_widget_color'))) {
	t_css_color($sout,'.widget-area',$widgetColor);
    }
    if (($widgetColor = ttw_getopt('ttw_widget_color_css'))) {
	t_css_css($sout,'.widget-area',$widgetColor);
    }

/*  ttw_widget_header_underline  */

    $val = (int)ttw_getopt('ttw_widget_header_underline');       /* bar under widget */
    if ($val != '' && $val != 0) {
        $titleColor = ttw_getopt('ttw_widget_title_color');
        fwrite($sout, sprintf(".widget-title {border-bottom: $val"."px solid $titleColor; margin-bottom:5px;}\n"));
     }

/*  ttw_widget_item_bgcolor */

    if (($optVal = ttw_getopt('ttw_widget_item_bgcolor'))) {
	t_css_bgcolor($sout,'.widget-container',$optVal);
    }
    if (($optVal = ttw_getopt('ttw_widget_item_bgcolor_css'))) {
	t_css_css($sout,'.widget-container',$optVal);
    }

/*  ttw_widget_title_color  */

    if (($wigtitleColor = ttw_getopt_newcolor('ttw_widget_title_color'))) {
	t_css_color($sout,'.widget-title', $wigtitleColor);
	t_css_color($sout,'.widget_search label', $wigtitleColor);
	t_css_color($sout,'#wp-calendar caption', $wigtitleColor);
    }
    if (($wigtitleColor = ttw_getopt_newcolor('ttw_widget_title_color_css'))) {
	t_css_css($sout,'.widget-title', $wigtitleColor);
	t_css_css($sout,'.widget_search label', $wigtitleColor);
	t_css_css($sout,'#wp-calendar caption', $wigtitleColor);
    }

/*  ttw_wlink_color  */
/*  ttw_wlink_hover_color  */
/*  ttw_wlink_visited_color  */

    if (($optVal = ttw_getopt_newcolor('ttw_wlink_color'))) {
	t_css_color($sout,'#primary a:link, #secondary a:link, #altleft a:link, #altright a:link, #footer-widget-area a:link', $optVal);
    }
    if (($optVal = ttw_getopt_newcolor('ttw_wlink_hover_color'))) {
	t_css_color($sout,'#primary a:hover, #secondary a:hover, #altleft a:hover, #altright a:hover, #footer-widget-area a:hover', $optVal);
    }
    if (($optVal = ttw_getopt_newcolor('ttw_wlink_visited_color'))) {
	t_css_color($sout,'#primary a:visited, #secondary a:visited, #altleft a:visited, #altright a:visited, #footer-widget-area a:visited', $optVal);
    }
    if (($optVal = ttw_getopt('ttw_wlink_color_css'))) {
	t_css_css($sout,'#primary a:link, #secondary a:link, #altleft a:link, #altright a:link, #footer-widget-area a:link', $optVal);
    }
    if (($optVal = ttw_getopt('ttw_wlink_hover_color_css'))) {
	t_css_css($sout,'#primary a:hover, #secondary a:hover, #altleft a:hover, #altright a:hover, #footer-widget-area a:hover', $optVal);
    }
    if (($optVal = ttw_getopt('ttw_wlink_visited_color_css'))) {
	t_css_css($sout,'#primary a:visited, #secondary a:visited, #altleft a:visited, #altright a:visited, #footer-widget-area a:visited', $optVal);
    }

/*  ttw_wrap_shadow  */

    if (ttw_getopt('ttw_wrap_shadow')) {
	fwrite($sout, sprintf("#wrapper {box-shadow: 0 0 3px 3px rgba(0,0,0,0.25); -webkit-box-shadow: 0 0 3px 3px rgba(0,0,0,0.25); -moz-box-shadow: 0 0 3px 3px rgba(0,0,0,0.25);}\n"));
    }

}

define ('WVR_WIDTH', 940);
function ttw_sidebar_css($sout) {
    /* output the CSS to support different sidebars at different widths */

    $sidebars = ttw_getopt('ttw_sidebars');
    $themewidth = ttw_getopt('ttw_header_image_width');
    if (! $themewidth) $themewidth = '940';
    $sidebarwidth = ttw_getopt('ttw_sidebar_width');
    $sb_adjust = (int) ttw_getopt('ttw_border_adjust_sidebar');

    /* SIDEBAR layout - need to calculate and override items if change width.
     *	First, calculate and emit everything that is constant for each alternative:
     *	Footer width, site-info, site-generator, site-title, site-description.
     */
    $mw = (int) $themewidth;		/* main width */
    $fw = (int)((($mw+20)/4)-25);	/* footer width ((mainwidth+20)/4)-25  */
    $si = (int) ( ($mw - 40) * .50 );	/* site info = 60% of mainwidth-40*/
    $sg = (int) ( $mw - 50 - $si );	/* site generator - left over space */
    $caw = (int) $mw - 40;		/* mainwidth - 40 */
    $ocw = (int)($mw * .90);		/* one column width */
    $tbmult = 0.85;			// usually make top/bottom widget areas 85%
    if (ttw_getopt('ttw_wide_top_bottom')) $tbmult = 1;

    if ($mw != WVR_WIDTH)	{			/* non-default width means override footer, etc. */
	fwrite($sout, sprintf("#access .menu-header, #access2 .menu-header, div.menu, #colophon, #branding, #main, #wrapper { width: %dpx; }\n",$mw));
	fwrite($sout, sprintf("#footer-widget-area .widget-area {width: %dpx; }\n",$fw));
	fwrite($sout, sprintf("#site-info { width: %dpx;}\n",$si));
	fwrite($sout, sprintf("#site-generator {text-align:right; width: %dpx; }\n",$sg));
	fwrite($sout, sprintf("#site-title {width: 55%%;} "));
	fwrite($sout, sprintf("#site-description {text-align:right; padding-right: 20px; width: 40%%;}\n"));
	fwrite($sout, sprintf("#access, #access2 {width: %dpx; }\n",$mw));
	fwrite($sout, sprintf("#access .menu-header, #access2 .menu-header, div.menu {width: %dpx;}\n",$mw-12));
	fwrite($sout, sprintf("#content .attachment img {max-width: %dpx;}\n",$caw));
	fwrite($sout, sprintf(".single-attachment #content {width: %dpx;}\n",$caw));
	fwrite($sout, sprintf(".one-column #content {margin-left: %dpx; padding: 0; width: %dpx;}\n",(int)($mw*.05),$ocw));
	fwrite($sout, sprintf("#main {margin-bottom:4px;}\n"));
	$altcontainer = $mw - 240;
	// alt templates
	fwrite($sout, sprintf(".right-alt #container {width: %dpx;}
.right-alt #content {width: %dpx;}
.right-alt #content img {max-width: %dpx;}\n",$altcontainer, $altcontainer-20,$altcontainer-30));
	fwrite($sout, sprintf( ".left-alt #content {width: %dpx;}
.left-alt #contentl img {max-width: %dpx;}",$altcontainer-42, $altcontainer-50));
    }

    if ($sidebars == SB_none) { 	/* no sidebars - simply hide them */
	if ($themewidth != WVR_WIDTH || $sidebarwidth || $tbmult == 1) {
	    $sidebarwidth = 0; /* use default if not set */
	    /* contentwidth + primary_secondary_width == (mainwidth-50) */
	    $contentw = (int)($mw - 50 - $sidebarwidth);	/* from formula */
	    $containerw = (int)($contentw + 38);		/* contentwidth + 38 */
	    if (ttw_getopt('ttw_wide_top_bottom')) $ttwwid = $contentw;	// same as content?
	    else $ttwwid = (int)($contentw - 70);		/* contentwidth - 70 */

	    fwrite($sout, sprintf("#container { float: left; margin: 0 0px 4px 0; width: %dpx; }\n",$containerw));
	    fwrite($sout, sprintf("#content {width: %dpx; overflow:hidden; margin:0 0px 10px 0px; padding: 5px 0px 0px 20px;}\n",$contentw));
	    fwrite($sout, sprintf("#content img { max-width: %dpx;}\n",$contentw));
	    fwrite($sout, sprintf("#primary, #secondary { visibility:hidden; width:0px; height: 0px;}\n"));
	    if (ttw_getopt('ttw_wide_top_bottom')) fwrite($sout, sprintf("#ttw-top-widget, #ttw-bot-widget {width: %dpx; margin-left: 20px;}\n",$ttwwid));
	    else fwrite($sout, sprintf("#ttw-top-widget, #ttw-bot-widget {width: %dpx;}\n",$ttwwid));

	} else {	/* using defaults, so make shorter */

	    fwrite($sout, sprintf("#container { width:940px; margin: 0px 0px -30px 0px; }
#content { width: 860px; margin: 0 100px 30px 0px; overflow:hidden; padding-top: 10px;}
#content img { max-width: 860px;}
#primary { visibility:hidden; width:0px; height: 0px;}
#secondary { visibility:hidden; width:0px; height: 0px;}
#ttw-top-widget, #ttw-bot-widget {width: 800px;}
.one-column #content { margin: 0 0 0 80px; padding: 0; width: 860px;}\n"));
	}
    } elseif ($sidebars == SB_2c) {	/* 2 sidebars, main central column */
	if ($themewidth != WVR_WIDTH || $sidebarwidth || $tbmult == 1 || $sb_adjust != 0) {
	    if (! $sidebarwidth) $sidebarwidth = 220; /* use default if not set */
	    /* contentwidth = mainwidth - 40 - (2*sidebarwidth ) */
	    $contentw = (int)($mw - 40 - ($sidebarwidth*2));	/* from formula */
	    $containerw = (int)($mw);		/* same a mw */
	    $ttwwid = (int)($contentw * $tbmult);	/* 85%  or 100% */
	    if ($tbmult == 1) {$ttwmargin = $sidebarwidth+20; $ttwwid -= 10; }
	    else $ttwmargin = (int)($sidebarwidth + $contentw * .115);

	    if (ttw_getopt('ttw_useborders')) $second_left = (int)$sidebarwidth+6;
	    else $second_left = (int)$sidebarwidth+4;

	    fwrite($sout, sprintf("#container { width:%dpx; float:left; margin:0 0 4px 0px;}\n",$containerw));
	    fwrite($sout, sprintf("#content { width: %dpx; margin: 0px 0px 5px %dpx; overflow:hidden; padding: 5px 20px 4px 20px; }\n",
		$contentw,$sidebarwidth));
	    fwrite($sout, sprintf("#content img { max-width: %dpx;}\n",$contentw));
	    fwrite($sout, sprintf("#primary { width:%dpx; float:left; margin: 0 0 4px -%dpx; }\n",$sidebarwidth-6-$sb_adjust,$mw));
	    fwrite($sout, sprintf("#secondary { width:%dpx; float:left; margin: 0 0 4px -%dpx;}\n",$sidebarwidth-6-$sb_adjust,$second_left));
	    fwrite($sout, sprintf("#ttw-top-widget, #ttw-bot-widget {width: %dpx; margin-left: %dpx;}\n",$ttwwid, $ttwmargin));
	} else {	/* using defaults, so make shorter */
	    fwrite($sout, sprintf("#container { width:940px; float:left; margin:0 0 4px 0px; }
#content { width: 460px; margin: 0px 0px 5px 220px; overflow:hidden; padding: 5px 20px 4px 20px; }
#content img { max-width: 460px;}
#primary { width:214px; float:left; margin: 0 0 4px -940px; }
#secondary { width:214px; float:left; margin: 0 0 4px -226px;}
#ttw-top-widget, #ttw-bot-widget {width: 400px; margin-left: 265px;}
.one-column #content { margin: 0 0 0 0 px; padding: 0; width: 800px;}\n"));
	}
    } elseif ($sidebars == SB_2r) {
	if ($themewidth != WVR_WIDTH || $sidebarwidth || $tbmult == 1 || $sb_adjust != 0) {
	    if (! $sidebarwidth) $sidebarwidth = 220; /* use default if not set */
	    $sb2 = (int)($sidebarwidth*.75);
	    $contentw = (int)($mw - 60 - $sidebarwidth - $sb2);	/* from formula */
	    if (ttw_getopt('ttw_useborders')) $containerw = (int)($contentw + 36);
	    else $containerw = (int)($contentw + 40);
	    $ttwwid = (int)($contentw * $tbmult);
	    if ($tbmult == 1) { $ttwmargin = 0; $ttwwid += 5; }
	    else $ttwmargin = (int)($contentw*.115);

	    fwrite($sout, sprintf("#container { width:%dpx; float:left; margin:0 0px 4px 0px;}\n",$containerw));
	    fwrite($sout, sprintf("#content {width: %dpx; overflow:hidden; margin:0 0px 10px 0px; padding: 5px 0px 0px 20px;}\n",$contentw));
	    fwrite($sout, sprintf("#content img { max-width: %dpx;}\n",$contentw));
	    fwrite($sout, sprintf("#primary { width:%dpx; float:left; margin:0 0px 4px 0px;}\n",$sidebarwidth-$sb_adjust));
	    fwrite($sout, sprintf("#secondary { width:%dpx; float:left; margin:0 0 4px 0px;}\n",$sb2));
	    fwrite($sout, sprintf("#ttw-top-widget, #ttw-bot-widget {width: %dpx;margin-left:%dpx;}\n",$ttwwid,$ttwmargin));
	} else {	/* using defaults, so make shorter */
	fwrite($sout, sprintf("#container { width:525px; float:left; margin:0 0px 4px 0px;}
#content { width: 490px; overflow:hidden; margin:0 0px 10px 0px; padding: 5px 0px 0px 20px;}
#content img { max-width: 490px;}
#primary { width:220px; float:left; margin:0 0px 4px 0px;}
#secondary { width:170px; float:left; margin:0 0 4px 0px;}
#ttw-top-widget, #ttw-bot-widget {width: 420px; margin-left: 40px;}
.one-column #content { margin: 0 0 0 80px; padding: 0; width: 800px;}\n"));
	}
    } elseif ($sidebars == SB_2l) {
	if ($themewidth != WVR_WIDTH || $sidebarwidth || $tbmult == 1 || $sb_adjust != 0) {
	    if (! $sidebarwidth) $sidebarwidth = 220; /* use default if not set */
	    $sb2 = (int)($sidebarwidth*.75);
	    $contentw = (int)($mw - 60 - $sidebarwidth - $sb2);	/* from formula */
	    if (ttw_getopt('ttw_useborders')) $containerw = (int)($contentw + 36);
	    else $containerw = (int)($contentw + 40);
	    $ttwwid = (int)($contentw * $tbmult);
	    if ($tbmult == 1) $ttwmargin = 18;
	    else $ttwmargin = (int)($contentw*.115);

	    fwrite($sout, sprintf("#container { width:%dpx; float:right; margin:0 0 4px 0px;}\n",$containerw));
	    fwrite($sout, sprintf("#content { width: %dpx; overflow:hidden; float:right; padding: 5px 10px 5px 0px; margin:0 10px 4px 0px;}\n",$contentw));
	    fwrite($sout, sprintf("#content img { max-width: %dpx;}\n",$contentw));
	    fwrite($sout, sprintf("#primary { width:%dpx; float:left; margin:0 0px 4px 0px;}\n",$sidebarwidth-4-$sb_adjust));
	    fwrite($sout, sprintf("#secondary { width:%dpx; float:left; margin:0 0 4px 0px; clear:none;}\n",$sb2));
	    fwrite($sout, sprintf("#ttw-top-widget, #ttw-bot-widget {width: %dpx;margin-left:%dpx;}\n",$ttwwid,$ttwmargin));
	    fwrite($sout, sprintf(".one-column #content { margin-right: %dpx;}\n",(int)($mw*.05)));
	} else {	/* using defaults, so make shorter */
	    fwrite($sout, sprintf("#container { width:530px; float:right; margin:0 0 4px 0px;}
#content { width: 490px; overflow:hidden; float:right;  padding: 5px 10px 5px 0px; margin:0 10px 4px 0px;}
#content img { max-width: 490px;}
#primary { width:216px; float:left; margin:0 0px 4px 0px;}
#secondary { width:170px; float:left; margin:0 0 4px 0px; clear:none;}
#ttw-top-widget, #ttw-bot-widget {width: 420px;}
.one-column #content {margin: 0 60px 0 0px; padding: 0; width: 800px;}\n"));

	}
    } elseif ($sidebars == SB_1l) {
	if ($themewidth != WVR_WIDTH || $sidebarwidth || $tbmult == 1 || $sb_adjust != 0) {
	    if (! $sidebarwidth) $sidebarwidth = 220; /* use default if not set */
	    $contentw = (int)($mw - 70 - $sidebarwidth);	/* from formula */
	    $ttwwid = (int)($contentw * $tbmult);
	    if ($tbmult == 1) $ttwmargin = 30;
	    else $ttwmargin = (int)($contentw*.115);

	    fwrite($sout, sprintf("#container { float: right; margin: 0 -%dpx 4px 0; width: 100%%;}\n",$sidebarwidth+20));
	    fwrite($sout, sprintf("#content { margin: 0px %dpx 4px 0px; width: %dpx; padding: 10px 25px 5px 25px;}\n",
		$sidebarwidth+20,$contentw));
	    fwrite($sout, sprintf("#content img { max-width: %dpx;}\n",$contentw));
	    fwrite($sout, sprintf("#container.one-column-iframe #content {margin:0 0 0 -%dpx;padding:0px;width:100%%;}\n",$sidebarwidth+20));
	    fwrite($sout, sprintf("#primary, #secondary { float: left;  width: %dpx; padding-left: 15px; margin-bottom:4px;}\n",$sidebarwidth+3-$sb_adjust));
	    fwrite($sout, sprintf("#secondary { clear: left; }\n"));
	    fwrite($sout, sprintf("#ttw-top-widget, #ttw-bot-widget {width: %dpx; margin-left: %dpx;}\n",$ttwwid, $ttwmargin));
	    fwrite($sout, sprintf(".one-column #content { margin-left: %dpx;}\n",(int)($mw*.05-$sidebarwidth-20)));
  	} else {	/* using defaults, so make shorter */
	    fwrite($sout, sprintf( "#container { float: right; margin: 0 -240px 4px 0; width: 100%%;}
#content { margin: 0px 240px 4px 0px; width: 640px; padding: 10px 25px 5px 25px;}
#container.one-column-iframe #content {margin:0 0 0 -240px;padding:0;width:100%%;}
#content img { max-width: 640px;}
#primary, #secondary { float: left;  width: 223px; padding-left: 15px; margin-bottom:4px;}
#secondary { clear: left;}
#ttw-top-widget, #ttw-bot-widget {width: 580px;}
.one-column #content { margin: 0 0 0 -160px; padding: 0; width: 800px;}\n"));
	}
    } elseif ($sidebars == SB_1rw) {
	if ($themewidth != WVR_WIDTH || $sidebarwidth  || $tbmult == 1 || $sb_adjust != 0) {
	    if (! $sidebarwidth) $sidebarwidth = 300; /* use default if not set */
	    /* contentwidth + primary_secondary_width == (mainwidth-50) */
	    $contentw = (int)($mw - 50 - $sidebarwidth);	/* from formula */
	    $containerw = (int)($contentw + 38);		/* contentwidth + 38 */
	    $ttwwid = (int)($contentw - 70);		/* contentwidth - 70 */
	    if ($tbmult == 1) $ttwwid = $contentw;

	    fwrite($sout, sprintf("#container { float: left; margin: 0 0px 4px 0; width: %dpx; }\n",$containerw));
	    fwrite($sout, sprintf("#content {width: %dpx; overflow:hidden; margin:0 0px 10px 0px; padding: 5px 0px 0px 20px;}\n",$contentw));
	    fwrite($sout, sprintf("#content img { max-width: %dpx;}\n",$contentw));
	    fwrite($sout, sprintf("#primary, #secondary { float: right; overflow: hidden; width: %dpx; margin: 0 0 4px 0;}\n",$sidebarwidth-$sb_adjust));
	    if ($tbmult == 1) fwrite($sout, sprintf("#ttw-top-widget, #ttw-bot-widget {width: %dpx; margin-left: 1px; margin-right: 1px;}\n",$ttwwid));
	    else fwrite($sout, sprintf("#ttw-top-widget, #ttw-bot-widget {width: %dpx;}\n",$ttwwid));
	} else {	/* using defaults, so make shorter */
	    fwrite($sout, sprintf("#main {margin-bottom:4px;}
#container { float: left; margin: 0 0px 4px 0; width: 628px; }
#content {width: 590px; overflow:hidden; margin:0 0px 10px 0px; padding: 5px 0px 0px 20px;}
#content img { max-width: 590px;}
#primary, #secondary { float: right; overflow: hidden; width: 300px; margin: 0 0 4px 0;}
#ttw-top-widget, #ttw-bot-widget {width: 520px;}
.one-column #content { margin: 0 0 0 80px; padding: 0; width: 800px;}\n"));
	}
    } else {		/* default right sidebar */
	if ($themewidth != WVR_WIDTH || $sidebarwidth || $tbmult == 1 || $sb_adjust != 0) {
	    if (! $sidebarwidth) $sidebarwidth = 220; /* use default if not set */
	    /* contentwidth + primary_secondary_width == (mainwidth-50) */
	    $contentw = (int)($mw - 50 - $sidebarwidth);	/* from formula */
	    $containerw = (int)($contentw + 38);		/* contentwidth + 38 */
	    $ttwwid = (int)($contentw - 70);		/* contentwidth - 70 */
	    if ($tbmult == 1) $ttwwid = $contentw;

	    fwrite($sout, sprintf("#container { float: left; margin: 0 0px 4px 0; width: %dpx; }\n",$containerw));
	    fwrite($sout, sprintf("#content {width: %dpx; overflow:hidden; margin:0 0px 10px 0px; padding: 5px 0px 0px 20px;}\n",$contentw));
	    fwrite($sout, sprintf("#content img { max-width: %dpx;}\n",$contentw));
	    fwrite($sout, sprintf("#primary, #secondary { float: right; overflow: hidden; width: %dpx; margin: 0 0 4px 0;}\n",$sidebarwidth-$sb_adjust));
	    if ($tbmult == 1) fwrite($sout, sprintf("#ttw-top-widget, #ttw-bot-widget {width: %dpx; margin-left: 1px; margin-right: 1px;}\n",$ttwwid));
	    else fwrite($sout, sprintf("#ttw-top-widget, #ttw-bot-widget {width: %dpx;}\n",$ttwwid));
	}
    }
}

function t_css_fontfamily($sout, $name, $fontfamily) {
	/* fill in good set of alternate fonts */
	if (stripos($fontfamily,'(serif)')) {
		$altfont = "\"Times New Roman\", Times, serif";
	} elseif (stripos($fontfamily,'(sans-serif)')) {
		$altfont = 'Arial, Helvetica, sans-serif';
	} elseif (stripos($fontfamily,'(mono)')) {
		$altfont = 'Courier';
	} else { $altfont = 'serif';}

	$font = substr($fontfamily, 0 , strpos($fontfamily, ' (')); /* strip out font name */
	fwrite($sout, sprintf( "$name {font-family: \"". $font ."\", $altfont;}\n"));
}

function t_css_color($sout, $name, $color, $altstyle='') {
        /* output a CSS color rule */
	fwrite($sout, sprintf("$name {color: $color;$altstyle}\n"));
}

function t_css_css($sout, $name, $style) {
        /* output a CSS css rule */
	fwrite($sout, sprintf("%s %s\n",$name, $style));
}

function t_css_bgcolor($sout, $name, $color, $altstyle='') {
    /* output a CSS background-color rule */
	fwrite($sout, sprintf("$name {background-color: $color;$altstyle}\n"));
}
?>
